<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('trabalho_aluno', function (Blueprint $table) {
            $table->id();
            $table->foreignId('trabalho_id')->constrained('trabalhos')->onDelete('cascade');
            $table->foreignId('aluno_id')->constrained('alunos')->onDelete('cascade');
            $table->decimal('nota', 5, 2)->nullable();
            $table->text('observacoes')->nullable();
            $table->boolean('entregue')->default(false);
            $table->date('data_entrega')->nullable();
            $table->timestamps();
            
            $table->unique(['trabalho_id', 'aluno_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('trabalho_aluno');
    }
};



