<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('eventos', function (Blueprint $table) {
            $table->id();
            $table->string('titulo');
            $table->text('descricao')->nullable();
            $table->date('data');
            $table->time('hora_inicio')->nullable();
            $table->time('hora_fim')->nullable();
            $table->enum('tipo', ['Geral', 'Turma', 'Disciplina'])->default('Geral');
            $table->foreignId('turma_id')->nullable()->constrained()->onDelete('cascade');
            $table->foreignId('disciplina_id')->nullable()->constrained('disciplinas')->onDelete('cascade');
            $table->foreignId('ano_letivo_id')->constrained('ano_letivo')->onDelete('cascade');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('eventos');
    }
};



