<?php

namespace App\Services;

use App\Models\Aluno;

class CodigoEstudanteService
{
    /**
     * Gera um código de estudante único no formato AAAA00001
     * AAAA = ano de ingresso
     * 00001 = sequencial automático
     */
    public static function gerar($anoIngresso = null): string
    {
        if (!$anoIngresso) {
            $anoIngresso = date('Y');
        }

        // Busca o último código do ano
        $ultimoAluno = Aluno::where('codigo_estudante', 'like', $anoIngresso . '%')
            ->orderBy('codigo_estudante', 'desc')
            ->first();

        if ($ultimoAluno) {
            $ultimoNumero = (int) substr($ultimoAluno->codigo_estudante, 4);
            $novoNumero = $ultimoNumero + 1;
        } else {
            $novoNumero = 1;
        }

        return $anoIngresso . str_pad($novoNumero, 5, '0', STR_PAD_LEFT);
    }

    /**
     * Valida o formato do código de estudante
     */
    public static function validar($codigo): bool
    {
        return preg_match('/^\d{4}\d{5}$/', $codigo) === 1;
    }
}



