<?php

namespace App\Repositories;

use App\Models\User;
use Illuminate\Support\Facades\Hash;

class UserRepository
{
    public function create(array $dados): User
    {
        if (isset($dados['password'])) {
            $dados['password'] = Hash::make($dados['password']);
        }

        return User::create($dados);
    }

    public function update(User $user, array $dados): User
    {
        if (isset($dados['password'])) {
            $dados['password'] = Hash::make($dados['password']);
        }

        $user->update($dados);
        return $user->fresh();
    }

    public function findByEmail(string $email): ?User
    {
        return User::where('email', $email)->first();
    }

    public function findById(int $id): ?User
    {
        return User::find($id);
    }

    public function getAll()
    {
        return User::with(['roles', 'permissions'])->get();
    }
}



