<?php

namespace App\Repositories;

use App\Models\Professor;
use App\Models\User;
use App\Services\CodigoProfessorService;
use Illuminate\Support\Facades\Hash;

class ProfessorRepository
{
    public function create(array $dados): Professor
    {
        // Gera email único se não fornecido
        $email = $dados['email'] ?? null;
        if (!$email) {
            do {
                $email = 'professor_' . time() . '_' . rand(1000, 9999) . '@sge.pt';
            } while (User::where('email', $email)->exists());
        }
        
        // Cria o usuário primeiro
        $userData = [
            'name' => $dados['name'],
            'email' => $email,
            'password' => Hash::make($dados['password'] ?? date('Y')),
            'tipo' => 'professor',
            'must_change_password' => true,
            'is_active' => true,
        ];

        $user = User::create($userData);

        // Gera código do professor automaticamente
        $codigoProfessor = CodigoProfessorService::gerar();

        // Cria o professor
        $professorData = [
            'user_id' => $user->id,
            'numero_funcionario' => $codigoProfessor,
            'telefone' => $dados['telefone'] ?? null,
            'endereco' => $dados['endereco'] ?? null,
            'documento_identificacao' => $dados['documento_identificacao'] ?? null,
            'data_nascimento' => $dados['data_nascimento'] ?? null,
            'genero' => $dados['genero'] ?? null,
            'nivel_ensino' => $dados['nivel_ensino'] ?? 'AMBOS',
            'salario_fixo' => $dados['salario_fixo'] ?? null,
            'valor_hora' => $dados['valor_hora'] ?? null,
            'numero_dependentes' => $dados['numero_dependentes'] ?? 0,
        ];

        return Professor::create($professorData);
    }

    public function update(Professor $professor, array $dados): Professor
    {
        // Remove campos que não devem ser atualizados diretamente
        $professorData = $dados;
        unset($professorData['name'], $professorData['email']);
        
        $professor->update($professorData);

        // Atualiza dados do usuário se necessário
        if (isset($dados['name']) && $professor->user) {
            $professor->user->update(['name' => $dados['name']]);
        }
        
        // Email não é mais editável via formulário, mantém o existente

        return $professor->fresh();
    }

    public function getAll()
    {
        return Professor::with('user')->get();
    }
}

