<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Turma extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'turmas';

    protected $fillable = [
        'nome',
        'codigo',
        'nivel_ensino',
        'ano_letivo_id',
        'capacidade_maxima',
        'ativa',
    ];

    protected $casts = [
        'ativa' => 'boolean',
        'capacidade_maxima' => 'integer',
    ];

    public function anoLetivo()
    {
        return $this->belongsTo(AnoLetivo::class);
    }

    public function alunos()
    {
        return $this->belongsToMany(Aluno::class, 'turma_aluno')
            ->withPivot('ano_letivo_id')
            ->withTimestamps();
    }

    public function disciplinas()
    {
        return $this->belongsToMany(Disciplina::class, 'turma_disciplina_professor')
            ->withPivot('professor_id', 'ano_letivo_id')
            ->withTimestamps();
    }

    public function disciplinasAtribuidas()
    {
        return $this->belongsToMany(Disciplina::class, 'turma_disciplina')
            ->withPivot('ano_letivo_id', 'carga_horaria_semanal')
            ->withTimestamps();
    }

    public function professores()
    {
        return $this->belongsToMany(Professor::class, 'turma_disciplina_professor')
            ->withPivot('disciplina_id', 'ano_letivo_id')
            ->withTimestamps();
    }

    public function horarios()
    {
        return $this->hasMany(Horario::class);
    }

    public function eventos()
    {
        return $this->hasMany(Evento::class);
    }

    public function avaliacoes()
    {
        return $this->hasMany(Avaliacao::class);
    }

    public function trabalhos()
    {
        return $this->hasMany(Trabalho::class);
    }
}



