<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Trabalho extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'trabalhos';

    protected $fillable = [
        'titulo',
        'descricao',
        'disciplina_id',
        'turma_id',
        'professor_id',
        'ano_letivo_id',
        'data_entrega',
        'valor',
        'tipo',
        'arquivo',
        'nome_arquivo',
    ];

    protected $casts = [
        'data_entrega' => 'date',
        'valor' => 'decimal:2',
    ];

    public function disciplina()
    {
        return $this->belongsTo(Disciplina::class);
    }

    public function turma()
    {
        return $this->belongsTo(Turma::class);
    }

    public function professor()
    {
        return $this->belongsTo(Professor::class);
    }

    public function anoLetivo()
    {
        return $this->belongsTo(AnoLetivo::class);
    }

    public function alunos()
    {
        return $this->belongsToMany(Aluno::class, 'trabalho_aluno')
            ->withPivot('nota', 'observacoes', 'entregue', 'data_entrega')
            ->withTimestamps();
    }
}



