<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProfessorPayment extends Model
{
    use HasFactory;

    protected $fillable = [
        'professor_id',
        'mes',
        'ano',
        'horas_trabalhadas',
        'valor_total',
        'inss',
        'irps',
        'valor_liquido',
        'status',
        'data_pagamento',
        'observacoes',
        'created_by',
    ];

    protected $casts = [
        'mes' => 'integer',
        'ano' => 'integer',
        'horas_trabalhadas' => 'decimal:2',
        'valor_total' => 'decimal:2',
        'inss' => 'decimal:2',
        'irps' => 'decimal:2',
        'valor_liquido' => 'decimal:2',
        'data_pagamento' => 'date',
    ];

    public function professor()
    {
        return $this->belongsTo(Professor::class);
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function getMesNomeAttribute()
    {
        $meses = [
            1 => 'Janeiro', 2 => 'Fevereiro', 3 => 'Março', 4 => 'Abril',
            5 => 'Maio', 6 => 'Junho', 7 => 'Julho', 8 => 'Agosto',
            9 => 'Setembro', 10 => 'Outubro', 11 => 'Novembro', 12 => 'Dezembro'
        ];
        return $meses[$this->mes] ?? '';
    }
}
