<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PresencaProfessor extends Model
{
    use HasFactory;

    protected $table = 'presenca_professor';

    protected $fillable = [
        'professor_id',
        'marcado_em',
        'origem',
    ];

    protected $casts = [
        'marcado_em' => 'datetime',
    ];

    public function professor()
    {
        return $this->belongsTo(Professor::class);
    }
}
