<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PlanoTrimestral extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'planos_trimestrais';

    protected $fillable = [
        'professor_id',
        'disciplina_id',
        'turma_id',
        'trimestre_id',
        'ano_letivo_id',
        'arquivo',
        'nome_arquivo',
        'observacoes',
    ];

    public function professor()
    {
        return $this->belongsTo(Professor::class);
    }

    public function disciplina()
    {
        return $this->belongsTo(Disciplina::class);
    }

    public function turma()
    {
        return $this->belongsTo(Turma::class);
    }

    public function trimestre()
    {
        return $this->belongsTo(Trimestre::class);
    }

    public function anoLetivo()
    {
        return $this->belongsTo(AnoLetivo::class);
    }
}
