<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FuncionarioServicoPayment extends Model
{
    use HasFactory;

    protected $table = 'funcionario_servico_payments';

    protected $fillable = [
        'funcionario_servico_id',
        'mes',
        'ano',
        'valor_total',
        'inss',
        'irps',
        'valor_liquido',
        'status',
        'data_pagamento',
        'observacoes',
        'created_by',
    ];

    protected $casts = [
        'mes' => 'integer',
        'ano' => 'integer',
        'valor_total' => 'decimal:2',
        'inss' => 'decimal:2',
        'irps' => 'decimal:2',
        'valor_liquido' => 'decimal:2',
        'data_pagamento' => 'date',
    ];

    public function funcionarioServico()
    {
        return $this->belongsTo(FuncionarioServico::class, 'funcionario_servico_id');
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}

