<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckRole
{
    public function handle(Request $request, Closure $next, ...$roles): Response
    {
        if (!auth()->check()) {
            return redirect()->route('login');
        }

        $user = auth()->user();

        // Superadmin tem acesso a tudo
        if ($user->isSuperadmin()) {
            return $next($request);
        }

        // Processa roles que podem vir separadas por vírgula
        $allRoles = [];
        foreach ($roles as $role) {
            // Se a role contém vírgula, divide em múltiplas roles
            if (strpos($role, ',') !== false) {
                $allRoles = array_merge($allRoles, array_map('trim', explode(',', $role)));
            } else {
                $allRoles[] = trim($role);
            }
        }

        // Verifica se o usuário tem uma das roles necessárias
        foreach ($allRoles as $role) {
            if ($user->hasRole($role) || $user->tipo === $role) {
                return $next($request);
            }
        }

        abort(403, 'Acesso negado. Você não tem permissão para acessar este recurso.');
    }
}



