<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckPermission
{
    public function handle(Request $request, Closure $next, ...$permissions): Response
    {
        if (!auth()->check()) {
            return redirect()->route('login');
        }

        $user = auth()->user();

        // Superadmin e Admin têm acesso a tudo
        if ($user->isSuperadmin() || $user->isAdmin()) {
            return $next($request);
        }

        // Verifica se o usuário tem uma das permissões necessárias
        foreach ($permissions as $permission) {
            if ($user->hasPermission($permission)) {
                return $next($request);
            }
        }

        abort(403, 'Acesso negado. Você não tem permissão para acessar este recurso.');
    }
}



