<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Session;

class LanguageController extends Controller
{
    /**
     * Change the application language
     */
    public function switch(Request $request, $locale)
    {
        // Validate locale
        if (!in_array($locale, ['pt', 'en'])) {
            $locale = 'pt';
        }

        // Set locale in session
        Session::put('locale', $locale);
        
        // Set locale for current request
        App::setLocale($locale);
        
        // Save session immediately to ensure it persists
        Session::save();

        // Get the previous URL or default to dashboard
        $previousUrl = url()->previous();
        if (!$previousUrl || $previousUrl === route('language.switch', ['locale' => $locale])) {
            $previousUrl = route('dashboard');
        }

        // Redirect with success message
        return redirect($previousUrl)->with('success', trans('common.language_changed'));
    }
}

