<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\AnoLetivo;
use App\Models\Turma;
use App\Models\Aluno;
use App\Models\Avaliacao;
use App\Models\Financeiro;

class DashboardController extends Controller
{
    public function index()
    {
        $user = auth()->user();
        $anoLetivoAtivo = AnoLetivo::where('ativo', true)->first();

        $data = [
            'ano_letivo' => $anoLetivoAtivo,
        ];

        if ($user->isSuperadmin() || $user->isAdmin()) {
            $data['total_alunos'] = Aluno::count();
            $data['total_turmas'] = Turma::where('ativa', true)->count();
            $data['total_avaliacoes'] = Avaliacao::count();
            $data['total_professores'] = \App\Models\Professor::count();
            $data['total_disciplinas'] = \App\Models\Disciplina::where('ativa', true)->count();
            $data['total_eventos'] = \App\Models\Evento::where('ano_letivo_id', $anoLetivoAtivo?->id)->count();
            $data['total_trabalhos'] = \App\Models\Trabalho::where('ano_letivo_id', $anoLetivoAtivo?->id)->count();
            $data['eventos'] = \App\Models\Evento::where('ano_letivo_id', $anoLetivoAtivo?->id)
                ->with(['turma', 'disciplina'])
                ->get();
        } elseif ($user->isProfessor()) {
            // Redirecionar para dashboard específico do professor
            return redirect()->route('professor.dashboard');
        } elseif ($user->isAluno()) {
            // Redirecionar para dashboard específico do estudante
            return redirect()->route('aluno.dashboard');
        }

        return view('dashboard', $data);
    }
}
