<?php

namespace App\Exceptions;

use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Throwable;

class Handler extends ExceptionHandler
{
    /**
     * The list of the inputs that are never flashed to the session on validation exceptions.
     *
     * @var array<int, string>
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     */
    public function register(): void
    {
        $this->reportable(function (Throwable $e) {
            //
        });
    }

    /**
     * Render an exception into an HTTP response.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Throwable  $e
     * @return \Symfony\Component\HttpFoundation\Response
     *
     * @throws \Throwable
     */
    public function render($request, Throwable $e)
    {
        // Tratar ModelNotFoundException apenas para rotas específicas (destroy, edit, update, show)
        if ($e instanceof ModelNotFoundException) {
            $routeName = $request->route()->getName() ?? '';
            
            // Apenas tratar em rotas específicas que esperam encontrar um modelo
            $rotasEspecificas = ['destroy', 'edit', 'update', 'show', 'view'];
            $deveTratar = false;
            
            foreach ($rotasEspecificas as $rota) {
                if (strpos($routeName, $rota) !== false) {
                    $deveTratar = true;
                    break;
                }
            }
            
            // Se não for uma rota específica, deixar o Laravel tratar normalmente
            if (!$deveTratar) {
                return parent::render($request, $e);
            }
            
            $message = "O registo solicitado não foi encontrado ou foi eliminado.";

            if ($request->ajax() || $request->wantsJson()) {
                return response()->json([
                    'success' => false,
                    'message' => $message
                ], 404);
            }

            // Para requisições normais, redirecionar com mensagem de erro
            // Determinar rota de índice baseado no modelo
            if (strpos($routeName, 'disciplinas') !== false) {
                return redirect()->route('admin.disciplinas.index')
                    ->with('error', $message);
            } elseif (strpos($routeName, 'alunos') !== false) {
                return redirect()->route('admin.alunos.index')
                    ->with('error', $message);
            } elseif (strpos($routeName, 'professores') !== false) {
                return redirect()->route('admin.professores.index')
                    ->with('error', $message);
            } elseif (strpos($routeName, 'turmas') !== false) {
                return redirect()->route('admin.turmas.index')
                    ->with('error', $message);
            } elseif (strpos($routeName, 'funcionarios') !== false) {
                return redirect()->route('admin.funcionarios.index')
                    ->with('error', $message);
            }

            return redirect()->back()->with('error', $message);
        }

        return parent::render($request, $e);
    }
}

