<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Aluno;
use App\Models\Professor;

class VerificarUsuariosSemRelacionamento extends Command
{
    protected $signature = 'users:verificar-relacionamentos';
    protected $description = 'Verifica alunos e professores sem user associado';

    public function handle()
    {
        // Verificar alunos sem user
        $alunosSemUser = Aluno::whereDoesntHave('user')->count();
        $alunosComUserNull = Aluno::whereNull('user_id')->count();
        
        $this->info("Alunos sem relacionamento user: {$alunosSemUser}");
        $this->info("Alunos com user_id NULL: {$alunosComUserNull}");
        
        // Verificar professores sem user
        $professoresSemUser = Professor::whereDoesntHave('user')->count();
        $professoresComUserNull = Professor::whereNull('user_id')->count();
        
        $this->info("Professores sem relacionamento user: {$professoresSemUser}");
        $this->info("Professores com user_id NULL: {$professoresComUserNull}");
        
        // Verificar se há alunos com user mas is_active = false ou NULL
        $alunosComUserBloqueado = Aluno::whereHas('user', function($q) {
            $q->where(function($query) {
                $query->where('is_active', false)
                      ->orWhereNull('is_active');
            });
        })->count();
        
        $this->info("Alunos com user bloqueado: {$alunosComUserBloqueado}");
        
        // Verificar se há professores com user mas is_active = false ou NULL
        $professoresComUserBloqueado = Professor::whereHas('user', function($q) {
            $q->where(function($query) {
                $query->where('is_active', false)
                      ->orWhereNull('is_active');
            });
        })->count();
        
        $this->info("Professores com user bloqueado: {$professoresComUserBloqueado}");
        
        return 0;
    }
}
