<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use App\Models\Aluno;
use App\Models\Professor;
use Illuminate\Support\Facades\Hash;

class TestarLogin extends Command
{
    protected $signature = 'test:login {login} {password=2026}';
    protected $description = 'Testa o login de um usuário';

    public function handle()
    {
        $login = $this->argument('login');
        $password = $this->argument('password');
        
        $this->info("Testando login: {$login}");
        $this->info("Senha: {$password}\n");
        
        // Determina se é email, código de estudante ou número de funcionário
        $user = null;
        if (filter_var($login, FILTER_VALIDATE_EMAIL)) {
            $user = User::where('email', $login)->first();
            $this->line("Tentando como email...");
        } else {
            // Tenta como código de estudante
            $aluno = Aluno::where('codigo_estudante', $login)->first();
            if ($aluno) {
                $user = $aluno->user;
                $this->line("Tentando como código de estudante...");
            } else {
                // Tenta como número de funcionário do professor
                $professor = Professor::where('numero_funcionario', $login)->first();
                if ($professor) {
                    $user = $professor->user;
                    $this->line("Tentando como número de funcionário do professor...");
                }
            }
        }
        
        if (!$user) {
            $this->error("✗ Usuário não encontrado!");
            return 1;
        }
        
        $this->info("✓ Usuário encontrado:");
        $this->line("  - ID: {$user->id}");
        $this->line("  - Nome: {$user->name}");
        $this->line("  - Email: {$user->email}");
        $this->line("  - Tipo: {$user->tipo}");
        $this->line("  - is_active: " . var_export($user->is_active, true));
        
        // Verificar roles
        $roles = $user->roles->pluck('slug')->toArray();
        $this->line("  - Roles: " . implode(', ', $roles ?: ['NENHUMA']));
        
        // Verificar senha
        $senhaCorreta = Hash::check($password, $user->password);
        $this->line("  - Senha correta: " . ($senhaCorreta ? 'SIM' : 'NÃO'));
        
        if (!$senhaCorreta) {
            $this->warn("\nTestando outras senhas comuns...");
            $senhasTeste = ['2025', '2026', '2027', date('Y')];
            foreach ($senhasTeste as $senhaTeste) {
                if (Hash::check($senhaTeste, $user->password)) {
                    $this->info("  ✓ Senha correta encontrada: {$senhaTeste}");
                    break;
                }
            }
        }
        
        // Verificar se pode fazer login
        if (!$senhaCorreta) {
            $this->error("\n✗ NÃO PODE FAZER LOGIN - Senha incorreta");
            return 1;
        }
        
        if (!$user->is_active) {
            $this->error("\n✗ NÃO PODE FAZER LOGIN - Conta desativada");
            return 1;
        }
        
        if ($user->tipo === 'aluno' && !in_array('aluno', $roles)) {
            $this->error("\n✗ NÃO PODE FAZER LOGIN - Aluno sem role 'aluno'");
            return 1;
        }
        
        if ($user->tipo === 'professor' && !in_array('professor', $roles)) {
            $this->error("\n✗ NÃO PODE FAZER LOGIN - Professor sem role 'professor'");
            return 1;
        }
        
        $this->info("\n✓ PODE FAZER LOGIN com sucesso!");
        return 0;
    }
}
