<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use App\Models\Aluno;
use App\Models\Professor;
use Illuminate\Support\Facades\Hash;

class ResetarSenhasParaAnoAtual extends Command
{
    protected $signature = 'users:resetar-senhas-ano-atual {--ano=} {--force}';
    protected $description = 'Reseta todas as senhas de alunos e professores para o ano atual';

    public function handle()
    {
        $ano = $this->option('ano') ?: date('Y');
        
        $this->info("Resetando senhas para o ano: {$ano}");
        $this->warn("ATENÇÃO: Isso irá alterar a senha de TODOS os alunos e professores!");
        
        if (!$this->option('force') && !$this->confirm('Deseja continuar?')) {
            $this->info('Operação cancelada.');
            return 0;
        }
        
        $senhaHash = Hash::make($ano);
        
        // Resetar senhas de alunos
        $alunos = Aluno::with('user')->get();
        $alunosResetados = 0;
        
        $this->info("\nResetando senhas de alunos...");
        $bar = $this->output->createProgressBar($alunos->count());
        $bar->start();
        
        foreach ($alunos as $aluno) {
            if ($aluno->user) {
                $aluno->user->password = $senhaHash;
                $aluno->user->must_change_password = true;
                $aluno->user->save();
                $alunosResetados++;
            }
            $bar->advance();
        }
        
        $bar->finish();
        $this->newLine();
        
        // Resetar senhas de professores
        $professores = Professor::with('user')->get();
        $professoresResetados = 0;
        
        $this->info("\nResetando senhas de professores...");
        $bar = $this->output->createProgressBar($professores->count());
        $bar->start();
        
        foreach ($professores as $professor) {
            if ($professor->user) {
                $professor->user->password = $senhaHash;
                $professor->user->must_change_password = true;
                $professor->user->save();
                $professoresResetados++;
            }
            $bar->advance();
        }
        
        $bar->finish();
        $this->newLine(2);
        
        $this->info("✓ Senhas resetadas com sucesso!");
        $this->line("  - Alunos: {$alunosResetados}");
        $this->line("  - Professores: {$professoresResetados}");
        $this->line("  - Nova senha: {$ano}");
        $this->warn("\n⚠️  Todos os usuários precisarão alterar a senha no próximo login!");
        
        return 0;
    }
}
