<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Database\Seeders\ResetarTodasTabelasSeeder;

class ResetDatabaseCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'db:reset {--force : Força o reset sem confirmação}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Resetar todas as tabelas do banco de dados (remove todos os dados)';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->warn('⚠️  ATENÇÃO: Este comando vai apagar TODOS os dados do banco de dados!');
        $this->warn('   Isso inclui alunos, professores, turmas, disciplinas, admins, funcionários, etc.');
        $this->newLine();
        
        if (!$this->option('force')) {
            if (!$this->confirm('Tem certeza que deseja continuar?', false)) {
                $this->info('Operação cancelada.');
                return 0;
            }
            
            $this->newLine();
            if (!$this->confirm('Esta ação é IRREVERSÍVEL. Confirma novamente?', false)) {
                $this->info('Operação cancelada.');
                return 0;
            }
        }
        
        $this->newLine();
        $this->info('Iniciando reset do banco de dados...');
        $this->newLine();
        
        try {
            $seeder = new ResetarTodasTabelasSeeder();
            $seeder->setCommand($this);
            $seeder->run();
            
            $this->newLine();
            $this->info('✅ Reset concluído com sucesso!');
            
            return 0;
        } catch (\Exception $e) {
            $this->error('❌ Erro ao resetar banco de dados: ' . $e->getMessage());
            return 1;
        }
    }
}
