<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use App\Models\Aluno;
use App\Models\Professor;

class DesbloquearTodosForcado extends Command
{
    protected $signature = 'users:desbloquear-todos-forcado';
    protected $description = 'Desbloqueia TODOS os alunos e professores, verificando diretamente pelos modelos';

    public function handle()
    {
        // Desbloquear todos os alunos
        $alunos = Aluno::with('user')->get();
        $alunosDesbloqueados = 0;
        
        foreach ($alunos as $aluno) {
            if ($aluno->user) {
                if (!$aluno->user->is_active) {
                    $aluno->user->is_active = true;
                    $aluno->user->save();
                    $alunosDesbloqueados++;
                }
            }
        }
        
        $this->info("Alunos desbloqueados: {$alunosDesbloqueados}");
        
        // Desbloquear todos os professores
        $professores = Professor::with('user')->get();
        $professoresDesbloqueados = 0;
        
        foreach ($professores as $professor) {
            if ($professor->user) {
                if (!$professor->user->is_active) {
                    $professor->user->is_active = true;
                    $professor->user->save();
                    $professoresDesbloqueados++;
                }
            }
        }
        
        $this->info("Professores desbloqueados: {$professoresDesbloqueados}");
        
        // Verificar novamente
        $alunosAindaBloqueados = Aluno::whereHas('user', function($q) {
            $q->where(function($query) {
                $query->where('is_active', false)
                      ->orWhere('is_active', 0)
                      ->orWhereNull('is_active');
            });
        })->count();
        
        $professoresAindaBloqueados = Professor::whereHas('user', function($q) {
            $q->where(function($query) {
                $query->where('is_active', false)
                      ->orWhere('is_active', 0)
                      ->orWhereNull('is_active');
            });
        })->count();
        
        if ($alunosAindaBloqueados > 0 || $professoresAindaBloqueados > 0) {
            $this->warn("Ainda há {$alunosAindaBloqueados} alunos e {$professoresAindaBloqueados} professores bloqueados.");
            
            // Forçar atualização direta no banco
            $alunosIds = Aluno::pluck('user_id')->filter();
            $professoresIds = Professor::pluck('user_id')->filter();
            $todosIds = $alunosIds->merge($professoresIds)->unique();
            
            $atualizados = DB::table('users')
                ->whereIn('id', $todosIds)
                ->update([
                    'is_active' => 1,
                    'updated_at' => now()
                ]);
            
            $this->info("Forçada atualização direta no banco: {$atualizados} usuários atualizados.");
        } else {
            $this->info("✓ Todos os alunos e professores foram desbloqueados!");
        }
        
        return 0;
    }
}
