<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Turma;

class AtivarTodasTurmas extends Command
{
    protected $signature = 'turmas:ativar-todas';
    protected $description = 'Ativa todas as turmas no banco de dados';

    public function handle()
    {
        $turmas = Turma::all();
        $total = $turmas->count();
        $ativadas = 0;
        $jaAtivas = 0;
        
        $this->info("Verificando {$total} turmas...\n");
        
        foreach ($turmas as $turma) {
            if (!$turma->ativa) {
                $turma->ativa = true;
                $turma->save();
                $ativadas++;
            } else {
                $jaAtivas++;
            }
        }
        
        $this->info("✓ Processamento concluído!");
        $this->line("  - Total de turmas: {$total}");
        $this->line("  - Turmas ativadas: {$ativadas}");
        $this->line("  - Já estavam activas: {$jaAtivas}");
        
        return 0;
    }
}
