<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Aluno;
use App\Models\Role;

class AdicionarRoleAlunoATodos extends Command
{
    protected $signature = 'aluno:adicionar-role-todos';
    protected $description = 'Adiciona a role "aluno" a todos os usuários que são alunos';

    public function handle()
    {
        $roleAluno = Role::where('slug', 'aluno')->first();
        
        if (!$roleAluno) {
            $this->error('Role "aluno" não encontrada no banco de dados!');
            return 1;
        }
        
        $this->info("Role 'aluno' encontrada: ID {$roleAluno->id}");
        
        $alunos = Aluno::with('user')->get();
        $total = $alunos->count();
        $adicionados = 0;
        $jaTinham = 0;
        $semUser = 0;
        
        $this->info("Processando {$total} alunos...\n");
        
        $bar = $this->output->createProgressBar($total);
        $bar->start();
        
        foreach ($alunos as $aluno) {
            if (!$aluno->user) {
                $semUser++;
                $bar->advance();
                continue;
            }
            
            $user = $aluno->user;
            
            // Recarregar relacionamento roles
            $user->load('roles');
            
            if (!$user->roles->contains($roleAluno->id)) {
                $user->roles()->attach($roleAluno->id);
                $adicionados++;
            } else {
                $jaTinham++;
            }
            
            $bar->advance();
        }
        
        $bar->finish();
        $this->newLine(2);
        
        $this->info("✓ Processamento concluído!");
        $this->line("  - Total de alunos: {$total}");
        $this->line("  - Roles adicionadas: {$adicionados}");
        $this->line("  - Já tinham a role: {$jaTinham}");
        $this->line("  - Sem user associado: {$semUser}");
        
        return 0;
    }
}
