# Sistema de Gestão Escolar Integrado (SGE)

Sistema completo de gestão escolar desenvolvido com Laravel, MySQL, Bootstrap, JavaScript e CSS.

## Características

- **Gestão de Utilizadores**: Sistema RBAC completo com Superadmin, Admin, Funcionário, Professor e Aluno
- **Gestão Académica**: Turmas, disciplinas, horários, eventos
- **Sistema de Avaliação**: Suporte para Sistema Nacional e Cambridge
- **Gestão Financeira**: Mensalidades, pagamentos, dívidas
- **Autenticação Segura**: Login com email ou código de estudante
- **Temas Configuráveis**: Cores personalizáveis pelo Superadmin
- **Auditoria Completa**: Logs de todas as ações importantes

## Requisitos

- PHP >= 8.1
- Composer
- MySQL >= 5.7
- Node.js e NPM

## Instalação

### Windows (XAMPP) - Veja INSTALACAO_WINDOWS.md para problemas comuns

1. **Resolva dependências necessárias:**
   - Ative a extensão `zip` no `php.ini` (remova `;` de `;extension=zip`)
   - Instale o Git: https://git-scm.com/download/win
   - Instale o Node.js: https://nodejs.org/

2. Clone o repositório ou extraia os arquivos:
```bash
cd escola
```

3. Instale as dependências PHP:
```bash
composer install
```

4. Instale as dependências Node:
```bash
npm install
```

5. Copie o arquivo `.env.example` para `.env`:
```bash
# Windows PowerShell
copy .env.example .env

# Linux/Mac
cp .env.example .env
```

6. Configure o arquivo `.env` com suas credenciais de banco de dados:
```env
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=sge
DB_USERNAME=root
DB_PASSWORD=
```

7. **Crie o banco de dados no MySQL:**
   - Abra phpMyAdmin (http://localhost/phpmyadmin)
   - Crie um banco de dados chamado `sge`

8. Gere a chave da aplicação:
```bash
php artisan key:generate
```

9. Execute as migrations e seeders:
```bash
php artisan migrate --seed
```

10. Compile os assets:
```bash
npm run build
```

**⚠️ IMPORTANTE:** Sempre que reiniciar o servidor, você precisa:
- **Opção 1 (Recomendado para desenvolvimento):** Manter o Vite rodando em um terminal separado:
  ```bash
  # Terminal 1
  npm run dev
  
  # Terminal 2
  php artisan serve
  ```
- **Opção 2 (Para produção/testes):** Compilar os assets antes de iniciar:
  ```bash
  npm run build
  php artisan serve
  ```

11. Inicie o servidor:
```bash
php artisan serve
```

## Acesso Inicial

- **URL**: http://localhost:8000
- **Email**: superadmin@sge.pt
- **Senha**: admin123

## Estrutura do Sistema

### Tipos de Utilizadores

#### Superadmin
- Criar, editar, bloquear e eliminar Admins
- Configurar modelo de avaliação global
- Configurar ano letivo ativo e trimestres
- Gerir grade boundaries Cambridge
- Definir identidade visual

#### Admin
- Criar e gerir funcionários, professores e alunos
- Criar e gerir turmas, disciplinas, horários e eventos
- Alocar professores e alunos
- Gerir finanças

#### Funcionário
- Permissões configuráveis pelo Admin
- Pode ter permissões para: registar alunos, registar professores, gestão financeira, etc.

#### Professor
- Visualizar turmas e disciplinas atribuídas
- Lançar notas, trabalhos e TPC
- Senha inicial: ano atual
- Obrigado a alterar senha no primeiro login

#### Aluno
- Visualizar notas, trabalhos, horários e eventos
- Visualizar situação financeira
- Login com código de estudante
- Senha inicial: ano atual
- Obrigado a alterar senha no primeiro login

## Código de Estudante

Formato: `AAAA00001`
- AAAA: ano de ingresso
- 00001: sequencial automático
- Único e imutável

## Modelos de Avaliação

### Sistema Nacional
- Teste 1 (40%)
- Teste 2 (40%)
- Avaliação Final (60%)
- Média = ((teste1 + teste2) * 0.40) + (avaliacao_final * 0.60)

### Sistema Cambridge
- Midterm Exam
- Term Exam
- Percentagem Final = (midterm + term) / 2
- Conversão para letras baseada em grade boundaries configuráveis

## Segurança

- Hash de senha com bcrypt
- RBAC validado no backend
- Forçar mudança de senha no primeiro login
- Logs obrigatórios para ações importantes
- Validações sempre no backend

## Desenvolvimento

### Modo Desenvolvimento (com hot reload - CSS atualiza automaticamente)

Abra **dois terminais**:

**Terminal 1 - Vite (compila CSS/JS em tempo real):**
```bash
npm run dev
```

**Terminal 2 - Laravel:**
```bash
php artisan serve
```

### Modo Produção (CSS compilado - não precisa do Vite rodando)

Se você não quiser manter o Vite rodando, compile os assets antes de iniciar:
```bash
npm run build
php artisan serve
```

**⚠️ Nota:** Se o CSS desaparecer após reiniciar o servidor, é porque o Vite não está rodando. Execute `npm run build` para compilar os assets ou use `npm run dev` em um terminal separado.

### Scripts Auxiliares (Windows)

- `build-assets.bat` - Compila os assets CSS/JS
- `start-dev.bat` - Inicia automaticamente o Vite e o Laravel em terminais separados

## Licença

MIT


