# Próximos Passos - Instalação do SGE

## ✅ O que já foi feito:

1. ✅ Dependências Node.js instaladas
2. ✅ Vulnerabilidades corrigidas (0 vulnerabilidades encontradas)
3. ✅ Estrutura do projeto criada

## 📋 Próximos passos:

### 1. Instalar dependências PHP (se ainda não fez)

```powershell
composer install
```

**Se tiver problemas:**
- Ative a extensão `zip` no `C:\xampp\php\php.ini` (remova `;` de `;extension=zip`)
- Instale o Git: https://git-scm.com/download/win
- Reinicie o terminal após instalar o Git

### 2. Configurar arquivo .env

```powershell
# Copiar arquivo de exemplo
copy .env.example .env
```

Edite o arquivo `.env` e configure:

```env
DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=sge
DB_USERNAME=root
DB_PASSWORD=
```

### 3. Criar banco de dados

1. Abra o phpMyAdmin: http://localhost/phpmyadmin
2. Clique em "Novo" no menu lateral
3. Nome do banco: `sge`
4. Clique em "Criar"

### 4. Gerar chave da aplicação

```powershell
php artisan key:generate
```

### 5. Executar migrations e seeders

```powershell
php artisan migrate --seed
```

Isso criará todas as tabelas e dados iniciais, incluindo:
- Usuário superadmin (email: superadmin@sge.pt, senha: admin123)
- Roles e permissions
- Ano letivo atual
- Disciplinas padrão

### 6. Compilar assets

```powershell
npm run build
```

### 7. Iniciar servidor

```powershell
php artisan serve
```

### 8. Acessar o sistema

Abra no navegador: **http://localhost:8000**

**Credenciais iniciais:**
- Email: `superadmin@sge.pt`
- Senha: `admin123`

## 🔧 Comandos úteis

**Desenvolvimento (com hot reload):**
```powershell
# Terminal 1
php artisan serve

# Terminal 2
npm run dev
```

**Produção:**
```powershell
npm run build
php artisan serve
```

**Limpar cache:**
```powershell
php artisan cache:clear
php artisan config:clear
php artisan view:clear
```

**Ver rotas disponíveis:**
```powershell
php artisan route:list
```

## ⚠️ Problemas comuns

**Erro: "Class 'PDO' not found"**
- Ative `pdo_mysql` no php.ini

**Erro: "mbstring extension not found"**
- Ative `mbstring` no php.ini

**Erro ao executar migrations**
- Verifique se o banco de dados foi criado
- Verifique credenciais no .env
- Certifique-se de que o MySQL está rodando

**Página em branco**
- Execute: `php artisan config:clear`
- Verifique permissões da pasta `storage`
- Verifique logs em `storage/logs/laravel.log`

## 📚 Documentação

- Veja `README.md` para informações gerais
- Veja `INSTALACAO_WINDOWS.md` para problemas específicos do Windows

