# Guia de Instalação no Windows (XAMPP)

## Problemas Comuns e Soluções

### 1. Erro: "The zip extension and unzip/7z commands are both missing"

**Solução:**

1. Abra o arquivo `C:\xampp\php\php.ini` no bloco de notas (como administrador)

2. Procure pela linha que contém `;extension=zip` e remova o ponto e vírgula:
   ```ini
   ;extension=zip  ← Remova o ; para ficar:
   extension=zip
   ```

3. Salve o arquivo e reinicie o Apache no XAMPP

4. Verifique se a extensão está ativa:
   ```powershell
   php -m | findstr zip
   ```
   Deve retornar "zip"

### 2. Erro: "git was not found in your PATH"

**Solução:**

1. Baixe e instale o Git para Windows: https://git-scm.com/download/win

2. Durante a instalação, certifique-se de marcar a opção "Add Git to PATH"

3. Reinicie o PowerShell/Terminal após a instalação

4. Verifique se o Git está instalado:
   ```powershell
   git --version
   ```

### 3. Instalação Completa

Após resolver os problemas acima:

```powershell
# 1. Instalar dependências PHP
composer install

# 2. Copiar arquivo .env
copy .env.example .env

# 3. Gerar chave da aplicação
php artisan key:generate

# 4. Configurar banco de dados no .env
# Edite o arquivo .env e configure:
# DB_CONNECTION=mysql
# DB_HOST=127.0.0.1
# DB_PORT=3306
# DB_DATABASE=sge
# DB_USERNAME=root
# DB_PASSWORD=

# 5. Criar banco de dados no MySQL
# Abra o phpMyAdmin (http://localhost/phpmyadmin)
# Crie um banco de dados chamado "sge"

# 6. Executar migrations e seeders
php artisan migrate --seed

# 7. Instalar dependências Node.js
npm install

# 8. Compilar assets
npm run build

# 9. Iniciar servidor
php artisan serve
```

### 4. Verificações Adicionais

**Verificar extensões PHP necessárias:**
```powershell
php -m
```

Certifique-se de que estas extensões estão ativas:
- zip
- mbstring
- openssl
- pdo_mysql
- tokenizer
- xml
- ctype
- json
- fileinfo

**Se alguma estiver faltando:**

1. Abra `C:\xampp\php\php.ini`
2. Procure pela extensão (ex: `;extension=mbstring`)
3. Remova o `;` no início da linha
4. Salve e reinicie o Apache

### 5. Alternativa: Usar Composer sem Git (não recomendado)

Se não puder instalar o Git, você pode tentar:

```powershell
composer install --prefer-dist --no-scripts
```

Mas isso pode causar problemas com alguns pacotes.

### 6. Verificar Instalação

Após seguir todos os passos, acesse:
- URL: http://localhost:8000
- Email: superadmin@sge.pt
- Senha: admin123

## Troubleshooting

**Erro: "Class 'PDO' not found"**
- Ative a extensão `pdo_mysql` no php.ini

**Erro: "mbstring extension not found"**
- Ative a extensão `mbstring` no php.ini

**Erro ao executar migrations**
- Verifique se o banco de dados "sge" foi criado
- Verifique as credenciais no arquivo .env
- Certifique-se de que o MySQL está rodando no XAMPP

**Erro: "npm não é reconhecido"**
- Instale o Node.js: https://nodejs.org/
- Reinicie o terminal após a instalação

