# Sistema de Inscrições Públicas

## ✅ O que foi implementado:

### 1. **Migration**
- ✅ Adicionado campo `status_inscricao` (PENDENTE, APROVADO, REJEITADO)
- ✅ Adicionado campo `observacoes_inscricao` (texto)
- ✅ Adicionado campo `data_submissao` (timestamp)

### 2. **Controller Público** (`PublicInscricaoController`)
- ✅ `showForm()` - Mostra formulário público
- ✅ `store()` - Processa inscrição e cria aluno com status PENDENTE
- ✅ `success()` - Página de confirmação

### 3. **Controller Admin** (`AdminController`)
- ✅ `inscricoesPendentes()` - Lista inscrições pendentes
- ✅ `aprovarInscricao()` - Aprova inscrição e ativa usuário
- ✅ `rejeitarInscricao()` - Rejeita inscrição com observações
- ✅ `visualizarInscricao()` - Visualiza detalhes da inscrição

### 4. **Rotas**
- ✅ `/inscrever-se` (GET) - Formulário público
- ✅ `/inscrever-se` (POST) - Submeter inscrição
- ✅ `/inscricao-sucesso` - Página de sucesso
- ✅ `/admin/inscricoes/pendentes` - Lista de pendentes (protegida)
- ✅ `/admin/inscricoes/{aluno}/visualizar` - Ver detalhes (protegida)
- ✅ `/admin/inscricoes/{aluno}/aprovar` - Aprovar (protegida)
- ✅ `/admin/inscricoes/{aluno}/rejeitar` - Rejeitar (protegida)

### 5. **Modelo Aluno**
- ✅ Campos adicionados ao `$fillable`

## 📋 Próximos Passos:

### 1. Criar Views Públicas

Criar `resources/views/public/inscricao.blade.php`:
- Formulário baseado em `resources/views/admin/alunos/create.blade.php`
- Remover campos administrativos (turma, ano letivo, etc.)
- Manter campos essenciais do aluno
- Adicionar validação JavaScript
- Design responsivo e amigável

Criar `resources/views/public/inscricao-success.blade.php`:
- Mensagem de confirmação
- Informações sobre o processo de aprovação
- Link para voltar ao site

### 2. Criar Views Administrativas

Criar `resources/views/admin/inscricoes/pendentes.blade.php`:
- Tabela com inscrições pendentes
- Filtros e busca
- Botões para aprovar/rejeitar/visualizar
- Badge com status

Criar `resources/views/admin/inscricoes/visualizar.blade.php`:
- Detalhes completos da inscrição
- Botões para aprovar/rejeitar
- Campo para observações

### 3. Integração com Website

Para integrar no website da escola:

**Opção 1: Iframe**
```html
<iframe src="https://seu-sistema.com/inscrever-se" width="100%" height="800px"></iframe>
```

**Opção 2: Link direto**
```html
<a href="https://seu-sistema.com/inscrever-se" target="_blank">
    Inscreva-se aqui
</a>
```

**Opção 3: Formulário customizado (API)**
- Criar endpoint API `/api/inscricao` (futuro)
- Website envia dados via AJAX
- Sistema processa e retorna resposta

## 🔧 Como usar:

### Para Encarregados:
1. Acessar `/inscrever-se`
2. Preencher formulário completo
3. Submeter inscrição
4. Receber confirmação
5. Aguardar aprovação da administração

### Para Administradores:
1. Acessar `/admin/inscricoes/pendentes`
2. Visualizar lista de inscrições pendentes
3. Clicar em "Visualizar" para ver detalhes
4. Aprovar ou rejeitar com observações
5. Aluno aprovado é ativado automaticamente

## 📝 Notas Importantes:

- Alunos criados via formulário público têm `is_active = false` até aprovação
- Status inicial é sempre `PENDENTE`
- Email é gerado automaticamente se não fornecido
- Senha padrão é o ano atual (ex: 2026)
- Usuário deve alterar senha no primeiro login

## 🎨 Personalização:

Para personalizar o formulário público:
1. Editar `resources/views/public/inscricao.blade.php`
2. Adicionar CSS customizado
3. Adicionar logo da escola
4. Ajustar campos obrigatórios/opcionais

## 🔐 Segurança:

- Formulário público não requer autenticação
- Validação completa dos dados
- Proteção contra spam (pode adicionar reCAPTCHA)
- Dados sensíveis protegidos
