# Guia de Integração - Colégio Premium

## 🌐 Informações do Website

- **Website**: https://www.colegiopremium.edu.mz/
- **Sistema Laravel**: (Precisa descobrir a URL)

---

## 🔍 Passo 1: Descobrir a URL do Sistema

Antes de integrar, você precisa saber onde está hospedado o sistema Laravel. Pode estar em:

1. **Subdomínio**: `https://sistema.colegiopremium.edu.mz/`
2. **Subpasta**: `https://www.colegiopremium.edu.mz/sistema/`
3. **Domínio diferente**: `https://sge.colegiopremium.edu.mz/`

**Como descobrir:**
- Verifique com quem configurou o sistema
- Ou teste acessando diretamente: `https://www.colegiopremium.edu.mz/inscrever-se`

---

## 📝 Passo 2: Escolher o Método de Integração

### **Método A: Link Direto (Recomendado para começar)**

Cole este código no seu website onde quiser o botão de inscrição:

```html
<!-- Seção de Inscrições -->
<section style="text-align: center; padding: 40px 20px; background: #f8f9fa;">
    <h2 style="color: #333; margin-bottom: 15px;">Inscrições Abertas</h2>
    <p style="color: #666; margin-bottom: 25px;">
        Preencha o formulário online e aguarde a aprovação da administração.
    </p>
    
    <!-- IMPORTANTE: Substitua pela URL real do seu sistema -->
    <a href="https://SEU-SISTEMA/inscrever-se" 
       target="_blank" 
       style="display: inline-block; padding: 15px 30px; background: #0066cc; color: white; text-decoration: none; border-radius: 5px; font-weight: bold;">
        Inscrever-se Agora
    </a>
</section>
```

**Onde colocar:**
- Na página inicial (homepage)
- Em uma página dedicada de "Inscrições" ou "Matrículas"
- No menu de navegação

---

### **Método B: Iframe (Formulário dentro do site)**

Se você quer que o formulário apareça dentro do seu website:

```html
<!-- Seção com formulário integrado -->
<section style="padding: 40px 20px;">
    <div style="max-width: 900px; margin: 0 auto;">
        <h2 style="text-align: center; margin-bottom: 30px;">Formulário de Inscrição</h2>
        
        <iframe 
            src="https://SEU-SISTEMA/inscrever-se" 
            width="100%" 
            height="1200px" 
            frameborder="0"
            style="border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1);">
        </iframe>
    </div>
</section>
```

**Vantagem:** O usuário não sai do seu site

---

### **Método C: Popup/Janela**

Abre o formulário em uma nova janela:

```html
<button onclick="window.open('https://SEU-SISTEMA/inscrever-se', 'Inscricao', 'width=900,height=800')" 
        style="padding: 15px 30px; background: #0066cc; color: white; border: none; border-radius: 5px; cursor: pointer; font-weight: bold;">
    Inscrever-se Agora
</button>
```

---

## 🎨 Exemplos Práticos por Plataforma

### **Se seu site é HTML estático:**

Crie uma página `inscricoes.html`:

```html
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Inscrições - Colégio Premium</title>
</head>
<body>
    <h1>Inscrições Abertas</h1>
    <p>Preencha o formulário online:</p>
    <a href="https://SEU-SISTEMA/inscrever-se" target="_blank">Inscrever-se</a>
</body>
</html>
```

### **Se seu site é WordPress:**

1. Vá em **Páginas → Adicionar Nova**
2. Cole este código no editor (modo HTML):

```html
<h2>Inscrições Abertas</h2>
<p>Preencha o formulário online:</p>
<a href="https://SEU-SISTEMA/inscrever-se" target="_blank" class="button">Inscrever-se Agora</a>
```

Ou use um shortcode (adicione no `functions.php`):

```php
function botao_inscricao() {
    return '<a href="https://SEU-SISTEMA/inscrever-se" target="_blank" class="button">Inscrever-se</a>';
}
add_shortcode('inscricao', 'botao_inscricao');
```

Depois use `[inscricao]` no conteúdo.

### **Se seu site é PHP:**

```php
<?php
// No seu arquivo PHP
?>
<section>
    <h2>Inscrições Abertas</h2>
    <a href="https://SEU-SISTEMA/inscrever-se" target="_blank">Inscrever-se</a>
</section>
```

---

## 🔧 Personalização

### **Adicionar ao Menu de Navegação**

No menu do seu site, adicione um item:

```html
<li><a href="https://SEU-SISTEMA/inscrever-se" target="_blank">Inscrições</a></li>
```

### **Adicionar Banner/Widget**

Crie um banner chamativo:

```html
<div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); padding: 40px; text-align: center; color: white; margin: 20px 0;">
    <h2 style="margin: 0 0 15px 0;">Inscrições Abertas para 2026</h2>
    <p style="margin: 0 0 20px 0;">Garanta a vaga do seu filho!</p>
    <a href="https://SEU-SISTEMA/inscrever-se" 
       target="_blank"
       style="display: inline-block; padding: 15px 30px; background: white; color: #667eea; text-decoration: none; border-radius: 5px; font-weight: bold;">
        Inscrever-se Agora
    </a>
</div>
```

---

## ✅ Checklist de Implementação

- [ ] Descobrir a URL do sistema Laravel
- [ ] Escolher o método de integração (Link, Iframe ou Popup)
- [ ] Adicionar o código no website
- [ ] Testar o link/botão
- [ ] Verificar se o formulário abre corretamente
- [ ] Testar em mobile
- [ ] Adicionar ao menu de navegação (opcional)

---

## 🆘 Precisa de Ajuda?

1. **Não sei a URL do sistema**: Verifique com o desenvolvedor ou teste acessando diretamente
2. **O link não funciona**: Verifique se a URL está correta e se o sistema está online
3. **Quero customizar mais**: Use o método Iframe e adicione CSS personalizado

---

## 📞 Próximos Passos

1. Descubra a URL do sistema Laravel
2. Escolha um dos métodos acima
3. Cole o código no seu website
4. Teste e ajuste conforme necessário

**Exemplo de URL completa do formulário:**
- `https://sistema.colegiopremium.edu.mz/inscrever-se`
- `https://www.colegiopremium.edu.mz/sistema/inscrever-se`
