# Guia de Deploy - Hospedagem Compartilhada

## Pré-requisitos da Hospedagem
- PHP 8.1 ou superior
- MySQL 5.7+ ou MariaDB 10.3+
- Extensões PHP: BCMath, Ctype, Fileinfo, JSON, Mbstring, OpenSSL, PDO, Tokenizer, XML, cURL

---

## Passo 1: Preparar os Arquivos

### No seu computador, execute:
```bash
# Verificações de qualidade antes do deploy
php artisan check:user-is-active-loading  # Verifica se is_active está sendo carregado corretamente

# Limpar caches
php artisan config:clear
php artisan cache:clear
php artisan view:clear
php artisan route:clear

# Compilar assets (já feito)
npm run build
```

---

## Passo 2: Criar o Banco de Dados

1. Acesse o **cPanel** da sua hospedagem
2. Vá em **Bancos de Dados MySQL**
3. Crie um novo banco (ex: `seuusuario_sige`)
4. Crie um usuário para o banco
5. Associe o usuário ao banco com **TODAS as permissões**
6. Anote: nome do banco, usuário e senha

---

## Passo 3: Configurar o .env

Crie um arquivo `.env` na raiz do projeto com:

```env
APP_NAME="SIGE - Sistema de Gestão Escolar"
APP_ENV=production
APP_KEY=
APP_DEBUG=false
APP_TIMEZONE=Africa/Luanda
APP_URL=https://seudominio.com

DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=seuusuario_sige
DB_USERNAME=seuusuario_banco
DB_PASSWORD=sua_senha

SESSION_DRIVER=file
CACHE_STORE=file
QUEUE_CONNECTION=sync
```

---

## Passo 4: Upload dos Arquivos

### Opção A: Upload Direto (public_html = public)

Se você pode configurar o **Document Root** para apontar para a pasta `public`:

1. Faça upload de **TODOS** os arquivos para uma pasta acima de `public_html` (ex: `/home/usuario/sige/`)
2. Configure o Document Root para `/home/usuario/sige/public`

### Opção B: Upload Tradicional (mais comum)

1. Faça upload de **TODOS** os arquivos da pasta `public/` para `public_html/`
2. Faça upload de **TODOS** os outros arquivos para uma pasta fora de public_html (ex: `/home/usuario/sige/`)
3. Edite o arquivo `public_html/index.php`:

```php
<?php

use Illuminate\Http\Request;

define('LARAVEL_START', microtime(true));

// Ajuste este caminho para onde estão os arquivos do Laravel
$laravelPath = dirname(__DIR__) . '/sige';

// Determine if the application is in maintenance mode...
if (file_exists($maintenance = $laravelPath.'/storage/framework/maintenance.php')) {
    require $maintenance;
}

// Register the Composer autoloader...
require $laravelPath.'/vendor/autoload.php';

// Bootstrap Laravel and handle the request...
(require_once $laravelPath.'/bootstrap/app.php')
    ->handleRequest(Request::capture());
```

---

## Passo 5: Gerar APP_KEY

### Se tiver acesso ao Terminal (SSH):
```bash
cd /home/usuario/sige
php artisan key:generate
```

### Se NÃO tiver acesso ao Terminal:
1. No seu computador local, execute: `php artisan key:generate --show`
2. Copie a chave gerada (ex: `base64:xxxxx...`)
3. Cole no arquivo `.env` na linha `APP_KEY=`

---

## Passo 6: Permissões de Pastas

Configure as permissões (via cPanel ou FTP):

```
storage/          -> 775
storage/logs/     -> 775
storage/framework/ -> 775
bootstrap/cache/  -> 775
```

---

## Passo 7: Executar Migrações

### Se tiver acesso ao Terminal (SSH):
```bash
cd /home/usuario/sige
php artisan migrate --force
php artisan db:seed --force
```

### Se NÃO tiver acesso ao Terminal:

1. Crie um arquivo temporário `migrate.php` na pasta `public_html/`:

```php
<?php
require dirname(__DIR__) . '/sige/vendor/autoload.php';
$app = require_once dirname(__DIR__) . '/sige/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);

echo "<pre>";
echo "Executando migrações...\n";
$kernel->call('migrate', ['--force' => true]);
echo $kernel->output();

echo "\nExecutando seeds...\n";
$kernel->call('db:seed', ['--force' => true]);
echo $kernel->output();
echo "</pre>";

// IMPORTANTE: Delete este arquivo após usar!
echo "<br><strong style='color:red'>APAGUE ESTE ARQUIVO AGORA!</strong>";
```

2. Acesse `https://seudominio.com/migrate.php` no navegador
3. **APAGUE o arquivo migrate.php imediatamente após usar!**

---

## Passo 8: Verificar

1. Acesse `https://seudominio.com`
2. Faça login com as credenciais padrão:
   - **Superadmin**: `superadmin@escola.com` / `password`
   - **Admin**: `admin@escola.com` / `password`

3. **IMPORTANTE**: Altere as senhas imediatamente após o primeiro acesso!

---

## Estrutura Final de Pastas

```
/home/usuario/
├── sige/                    (arquivos Laravel - FORA de public_html)
│   ├── app/
│   ├── bootstrap/
│   ├── config/
│   ├── database/
│   ├── resources/
│   ├── routes/
│   ├── storage/
│   ├── vendor/
│   └── .env
│
└── public_html/             (Document Root - arquivos públicos)
    ├── build/               (assets compilados)
    ├── index.php            (modificado para apontar para ../sige)
    ├── .htaccess
    ├── favicon.ico
    └── robots.txt
```

---

## Solução de Problemas

### Erro 500
- Verifique as permissões das pastas `storage/` e `bootstrap/cache/`
- Verifique se o `.env` está configurado corretamente
- Verifique o arquivo `storage/logs/laravel.log`

### Página em branco
- Ative `APP_DEBUG=true` temporariamente para ver o erro
- Lembre de voltar para `APP_DEBUG=false` depois!

### CSS/JS não carrega
- Verifique se a pasta `build/` foi enviada para `public_html/`
- Verifique se `APP_URL` está correto no `.env`

### Erro de banco de dados
- Verifique as credenciais no `.env`
- Verifique se o usuário tem permissão no banco

---

## Segurança Pós-Deploy

1. ✅ Alterar senhas padrão
2. ✅ Definir `APP_DEBUG=false`
3. ✅ Apagar arquivos temporários (migrate.php, etc.)
4. ✅ Configurar backup automático do banco
5. ✅ Configurar SSL (HTTPS)

